﻿var messaging = {
    context: $(".v-messaging"),
    datatable: null,
    refreshDataTable: function () {
        messaging.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-messagesTable").a4datatable({
            height: "full",
            displayColumnSelector: false,
            ajaxAction: a4.getAction("GetMessages", "CAPI", "Messaging"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id" },
                { "Name": "SenderName", "Title": resources.SenderName, "Data": "SenderName", "Width": "10%" },
                { "Name": "RecipientsNames", "Title": resources.To, "Data": "RecipientsNames", "Width": "10%", "Visible": false },
                { "Name": "MessageDate", "Title": resources.CreatedOn, "Data": "MessageDate", "Width": "5%", "Class": "no-wrap" },
                { "Name": "Subject", "Title": resources.Subject, "Data": "Subject", "Width":"20%" },
                { "Name": "Body", "Title": resources.Message, "Data": "ShortMessage", "Class": "no-wrap" },                
                { "Name": "MsgRead", "Title": resources.IsRead, "Data": "MsgRead", "Label": "MsgReadLabel", "Type": "boolean",  "ShowIcon": true }
            ],
            quickFilter: {
                "DisplayMode": "buttons",
                "IncludeAll": false,
                "Items": [
                    { "Label": resources.Received, "AjaxParams": { "type": 0 } },
                    { "Label": resources.Sent, "AjaxParams": { "type": 1 } }
                ]
            },
            localizableTexts: { "Search": resources.SearchMessages },
            defaultSorting: { Column: "MessageDate", Ascending: false },
            stateKey: "Messaging",
            allowRowSelection: true,
            toolBarItems: messaging.getToolBarItems(),
            displayContextMenu: true,
            contextMenuItems: messaging.getContextMenuItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");
                var messageType = rows[0].MessageType;
                
                switch (action) {
                    case "delete":
                        messaging.deleteMessage(ids, messageType);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "read":
                        messaging.readMessage(row.Id, row.MessageType);
                        break;
                    case "delete":
                        messaging.deleteMessage([row.Id], row.MessageType);
                        break;
                }
            },
            loadData: function (event, data) {
                if (data.ajaxParams.tableParams.QuickFilter) {
                    var type = data.ajaxParams.tableParams.QuickFilter.type;

                    $(this).a4datatable("toggleColumns", ["MsgRead", "SenderName"], type == 0);
                    $(this).a4datatable("toggleColumn", "RecipientsNames", type == 1);

                    var messageDateTitle = type == 0 ? resources.Received : resources.Sent;
                                        
                    $(this).a4datatable("changeColumnTitle", "MessageDate", messageDateTitle);
                }
            }
        });
    },
    deleteMessage: function (items, messageType) {
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        var message = messageType == 0 ? confirmDeleteReceivedMessageResources : confirmDeleteSentMessageResources;
        modalDialog.showConfirmDelete(message, function () {
            a4.callServerMethod(a4.getAction("DeleteMessages", "CAPI", "Messaging"), { type: messageType, messageIds: items },
            function (result) {
                messaging.refreshDataTable();
            });
        }, itemsCount);
    },
    readMessage: function (itemId, messageType) {
        modalDialog.showWindow(a4.getAction("MessageEditor", "CAPI", "Messaging", { type: messageType, id: itemId }), 500, 700, { afterClose: function () { messaging.refreshDataTable(); } });
    },
    getContextMenuItems: function () {
        return [{ "Action": "read", "Label": resources.Read },
                { "Action": "delete", "Label": resources.Delete }];
    },
    getToolBarItems: function () {
        return [{ "Action": "delete", "Label": resources.Delete }];
    },
    bindEvents: function () {
        messaging.context.on("click", ".h-newMessage", function () {
            modalDialog.showWindow(a4.getAction("MessageEditor", "CAPI", "Messaging", { type: 1, id: "" }), 500, 700, { afterClose: function () { messaging.refreshDataTable(); } });
        });
    }
}

var messageEditor = {
    context: null,
    recipientType: 0,
    CAPI_MODULE: 3,
    initialize: function () {
        this.context = $(".v-messageEditor");

        
        $(".h-recipientsAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetUsersForAutoComplete", "Shared"),
            valueProperty: "ExternalId",
            labelProperty: "Name",
            categoryProperty: "TypeLabel",
            tooltipProperty: "Description",
            altValueField: $("#RecipientsJson"),
            multipleSelection: true,
            hideSelectedItems: true,
            change: function () {
                var value = $(".h-recipientsAutoComplete", this.context).a4autocomplete("getValue");
                $("#RecipientsNames").val(_.pluck(value, "Name").join(', '));
                
                var property = _.contains([0], messageEditor.recipientType) ? "ExternalId" : "Id";
                $("#RecipientsObjectJson").val(_.pluck(value, property).join(', '));
            },
            render: {
                selected: function (item) {
                    var type = "";
                    
                    switch (messageEditor.recipientType) {
                        case 0:
                            type = "user";
                            break;
                        case 1:
                            type = "group";
                            break;
                        case 2:
                        case 3:
                            type = "folder";
                            break;
                    }

                    return voxco.icons.getIcon(type) + "<span class=\"item-label\">" + item.Name + "</span>";
                }
            }
        });
    },
    bindEvents: function(){
        $("input[name='RecipientType']").change(function () {
            $(".h-recipientsAutoComplete", messageEditor.context).a4autocomplete("clearValue");

            var recipient = $(this).val();
            var valueProperty = _.contains(["User"], recipient) ? "ExternalId" : "Id";
            $(".h-recipientsAutoComplete", messageEditor.context).a4autocomplete({ ajaxAction: messageEditor.getSelectedAction(recipient), valueProperty: valueProperty });
            $("#RecipientType").val(recipient);
        });
    },
    getSelectedAction: function (recipient) {
        var route = "";
        
        switch (recipient) {
            case "User":
                messageEditor.recipientType = 0;
                route = a4.getAction("GetUsersForAutoComplete", "Shared");
                break;
            case "Group":
                messageEditor.recipientType = 1;
                route = a4.getAction("GetUserGroups", "Users", "Settings", { multiModeOnly: true });
                break;
            case "Project":
                messageEditor.recipientType = 2;
                route = a4.getAction("GetCAPIProjects", "Home", "Project");
                break;
            case "Module":
                messageEditor.recipientType = 3;
                route = a4.getAction("GetStatisticsCAPIModulesForAutocomplete", "Home", "Project");
                break;

        }

        return route;
    }
}

$(document).ready(function () {
    if ($(".v-messaging").length > 0) {
        messaging.initializeDataTable();
        messaging.bindEvents();
    } else if ($(".v-messageEditor").length > 0) {
        messageEditor.initialize();
        messageEditor.bindEvents();
    }
});